<?php
// $Id$
/**
 * @file
 * price Modul
 */

function price_calculator(){
	
	$structure = new product_structure('frontend');
	$structure->fill();
	$products = new products($structure);
	$data = $products->ausgabe();
	
	$form['#prefix'] = '<h1 class="price">'.t('Price Calculator').'</h1><div id="products_frame">';
	$form['#suffix'] = '</div>';
	$form['#id'] = 'products_form';
	$form['material'] = array(
		'#prefix' => '<div id="products_list">',
		'#type' => 'select',
		'#options' => array(''=>t('Loading data...')),
		'#required' => FALSE,
		'#validated' => TRUE
	);
	$form['dimension'] = array(
		'#type' => 'select',
		'#options' => array(''=>t('Loading data...')),
		'#required' => FALSE,
		'#validated' => TRUE
	);
	$form['number'] = array(
		'#type' => 'select',
		'#options' => array(''=>t('Loading data...')),
		'#required' => FALSE,
		'#validated' => TRUE
	);
	$form['color'] = array(
		'#type' => 'select',
		'#options' => array(''=>t('Loading data...')),
		'#required' => FALSE,
		'#validated' => TRUE,
		'#suffix' => '</div>'
	);
	$form['description'] = array(
		'#type' => 'markup',
		'#prefix' => '<div id="products_description">',
		'#suffix' => '</div>',
		'#value' => nl2br(variable_get('price_comment', ''))
	);
	$form['comment2'] = array(
		'#type' => 'markup',
		'#prefix' => '<div id="products_comment2">',
		'#suffix' => '</div>',
		'#value' => nl2br(str_replace(' ','&nbsp;',variable_get('price_comment2', '')))
	);
	$form['box'] = array(
		'#type' => 'markup',
		'#prefix' => '<div id="products_box_calculate">',
		'#suffix' => '</div>',
		'#value' => '
			<div id="netto_row">
				<div class="label" valign="bottom">'.t('Net value').':</div>
				<div class="value_8"><font id="netto_result_8">0</font>&nbsp;Euro</div>
				<div class="spacer">&nbsp;</div>
				<div class="value"><font id="netto_result">0</font>&nbsp;Euro</div>
			</div>
			<div id="mwst_row">
				<div class="label">'.t('Value-added tax').':</div>
				<div class="value_8"><font id="mwst_result_8">0</font>&nbsp;Euro</div>
				<div class="spacer">&nbsp;</div>
				<div class="value"><font id="mwst_result">0</font>&nbsp;Euro</div>
			</div>
			<div id="total_row">
				<div class="label">'.t('Total amount').':</div>
				<div class="value_8"><font id="total_result_8">0</font>&nbsp;Euro</div>
				<div class="spacer">&nbsp;</div>
				<div class="value"><font id="total_result">0</font>&nbsp;Euro</div>
			</div>'
	);
	$form['quote'] = array(
		'#type' => 'fieldset',
		'#title' => t('Quote'),
		'#collapsible' => FALSE,
		'#prefix' => '<div class="price_quote">',
		'#suffix' => '</div>'
	);
	$form['quote']['company'] = array(
		'#type' => 'textfield',
		'#title' => t('Company'),
		'#required' => TRUE
	);
	$form['quote']['person'] = array(
		'#type' => 'textfield',
		'#title' => t('Contact person'),
		'#required' => TRUE
	);
	$form['quote']['email'] = array(
		'#type' => 'textfield',
		'#title' => t('eMail'),
		'#required' => TRUE
	);
	$form['quote']['phone'] = array(
		'#type' => 'textfield',
		'#title' => t('Phone'),
		'#required' => TRUE
	);
	$form['quote']['street'] = array(
		'#type' => 'textfield',
		'#title' => t('Street'),
		'#required' => TRUE
	);
	$form['quote']['city'] = array(
		'#type' => 'textfield',
		'#title' => t('ZIP-Code, City'),
		'#required' => TRUE
	);
	$form['quote']['phone'] = array(
		'#type' => 'textfield',
		'#title' => t('Phone'),
		'#required' => TRUE
	);
	$form['quote']['quote'] = array(
		'#type' => 'textarea',
		'#title' => t('Quote'),
		'#resizable' => FALSE,
		'#required' => TRUE
	);
	$form['quote']['file'] = array(
		'#type' => 'file',
		'#title' => t('File'),
		'#required' => FALSE
	);
	/*
	Sonderfarben und Stckzahlen auf
	Anfrage.
	
	Der Gesamtpreis versteht sich
	zuzglich Verpackungs- und
	Versandkosten.
	 */
	$form['submit'] = array(
		'#type' => 'submit',
		'#value' => t('Posting')
	);
	$form['#attributes'] = array(
		'enctype'=>'multipart/form-data'
	);
	return $form;
}

function price_calculator_validate($form, &$form_state){
	$email = $form_state['values']['email'];
	if(!validateEmailAddress($email)){
	    form_set_error('email',t('Please check your email address'));
	}
}

function price_calculator_submit($form, &$form_state){
	$m_value = $form_state['values']['material'];
	$d_value = $form_state['values']['dimension'];
	$n_value = $form_state['values']['number'];
	$c_value = $form_state['values']['color'];
	//$t_value = $form_state['values']['transparency'];
	$company = $form_state['values']['company'];
	$person = $form_state['values']['person'];
	$email = $form_state['values']['email'];
	$phone = $form_state['values']['phone'];
	$street = $form_state['values']['street'];
	$city = $form_state['values']['city'];
	$quote = $form_state['values']['quote'];
	
	$path = variable_get('file_directory_path','sites/default/files');
	$validators = array();
	
	$headers	= array();
	$mailkey	= 'price_mail';
	//$absender	= $person.' <'.$email.'>';
	$empfaenger = 'Tim Lepek <lepek@systematiker.com>';
	$absender	= $email;
	//$empfaenger = 'lepek@systematiker.com';
	
	$subject	= 'Preisanfrage';
		
	//drupal_set_message('<pre>'.print_r($_FILES,true).'</pre>');
	
	function umwandeln($str) {
		$ist  =array("Ä","Ö","Ü","ä","ö","ü","ß","€");
		$soll =array("&Auml;","&Ouml;","&Uuml;","&auml;","&ouml;","&uuml;","&szlig;","&#128;");
		$max=count($ist);
		for($i=0;$i<$max;$i++) {
			$str = str_replace($ist[$i],$soll[$i],$str);
		}
		return $str;
	}
	
	$trenner  = md5(uniqid(time()));
	$body = nl2br(umwandeln($quote));
	
	$messages = array(
    	'id' => 'price_anfrage',
    	'to' => $empfaenger,
    	'from' => $absender,
    	'language' => 'de',
    	'params' => '',
    	'subject' => $subject,
    	'body' => array()
  	);
	$headers = array();
	$headers['From'] = $absender;
	$headers['MIME-Version'] = "1.0";
	$headers['Content-Type'] = 'multipart/mixed;\n\tboundary="'.$trenner.'"\n';
	$headers['Content-Transfer-Encoding'] = "8bit";
	$messages['headers'] = $headers;
	
	$message  = "\n--$trenner\n";
	$message .= "Content-transfer-encoding: 8bit\r\n";
	$message .= "Content-type: text/html\n\n";
	$message .= $body."\n";
	$message .= "\n\n";
	
	if($file = @file_save_upload('file', $validators, $path)){
		$datei = $path.'/'.$_FILES['files']['name']['file'];
		$dateiname=$_FILES['files']['name']['file'];
		
		$message .= "\n--$trenner\n";
		$message .= "Content-Type: application/octetstream;\n\tname=$dateiname\n";
		$message .= "Content-Transfer-Encoding: base64\n";
		$message .= "Content-Disposition: attachment;\n\tfilename=$dateiname\n\n";
		
		$file_pointer = @fopen($datei,"rb");
		$filedata=@fread($file_pointer,@filesize($datei));
		@fclose($file_pointer);
		$filedata=@chunk_split(@base64_encode($filedata));
		
		$message.= $filedata;
    }else{
    	$message = $body;
    }
    
    $messages['body'] = $message;
    // send mail
    //drupal_mail_send($messages);
    
    drupal_mail('price', $empfaenger, $subject, $body);
    
    
	if($datei && $datei != ""){
		if(file_delete($datei)){
			$sql = "delete from {files} where filename='%s'";
			$result = db_query(db_rewrite_sql($sql), $dateiname);
		}
	}
}