<?php
// $Id$
/**
 * @file
 * Funktionen fuer das price Modul
 * 
 */

/**
 * Funktion zum Validieren der eMail Adresse
 */
function validateEmailAddress(&$address_to_validate, $strict = false) {
    //Fuehrende und folgende Leerzeichen werden ignoriert
    $address_to_validate = trim($address_to_validate);
    //E-Mail-Adresse in Kleinbuchstaben umwandeln
    $address_to_validate = strtolower($address_to_validate);
    //Liste der Zeichen, in Namen, Domain und Subdomain nicht erlaubt sind
    $illegal_string = '\\\\(\\n)@';
    //Teile des regulaeren Ausdrucks = name@subdomain.domain.toplevel
    $name      = '([^\\.'.$illegal_string.'][^'.$illegal_string.']?)+';
    $subdomain = '([^\\._'.$illegal_string.']+\\.)?';
    $domain    = '[^\\.\\-_'.$illegal_string.'][^\\._'.$illegal_string.']*[^\\.\\-_'.$illegal_string.']';
    $toplevel  = '([a-z]{2,4}|museum|travel)';
    //Als Beispiel: .museum und .travel sind die einzigen TLDs die laenger als vier Zeichen sind
    $regular_expression = '/^'.$name.'[@]'.$subdomain.$domain.'\.'.$toplevel.'$/';
    return preg_match($regular_expression, $address_to_validate) ? true : false;
}

function autofill(){
	if($_POST['step']=='start'){
		$output['materials'] = '';
		$output['dimensions'] = '';
		$output['numbers'] = '';
		$output['colors'] = '';
		$sql_r = "select mid,did,nid,cid from {price_relations} where start=1";
		$data_r = db_fetch_object(db_query($sql_r));
		
		$sqlm = "SELECT DISTINCT m.mid as mmid, m.value as value, m.label as label, r.mid as rmid
		FROM {price_relations} as r
		INNER JOIN {price_materials} as m ON r.mid=m.mid
		ORDER BY r.weight";
		$resultm = db_query($sqlm);
		while($datam = db_fetch_object($resultm)){
			$data_r->mid==$datam->mmid ? $selected = ' selected=selected' : $selected = '';
			$output['materials'] .= '<option value="'.$datam->value.'"'.$selected.'>'.$datam->label.'</option>\n';
		}	
		
		$sqld = "SELECT DISTINCT d.did as ddid, d.value as dvalue, d.label as dlabel, d.weight,
		r.mid as rmid, r.did as rdid
		FROM {price_relations} as r
		INNER JOIN {price_dimensions} as d ON r.did=d.did
		WHERE r.mid=%d
		ORDER BY d.weight";
		$resultd = db_query($sqld,$data_r->mid);
		while($datad = db_fetch_object($resultd)){
			$data_r->did==$datad->ddid ? $selected = ' selected=selected' : $selected = '';
			$output['dimensions'] .= '<option value="'.$datad->dvalue.'"'.$selected.'>'.$datad->dlabel.'</option>\n';
		}
		
		$sqln = "SELECT DISTINCT r.mid, r.did, r.nid, 
		n.nid AS nnid, n.value AS value, n.label AS label
		FROM {price_relations} AS r 
		INNER JOIN {price_numbers} AS n ON r.nid=n.nid
		WHERE r.mid=%d AND r.did=%d";
		$resultn = db_query($sqln,$data_r->mid,$data_r->did);
		while($datan = db_fetch_object($resultn)){
			$data_r->nid==$datan->nnid ? $selected = ' selected=selected' : $selected = '';
			$output['numbers'] .= '<option value="'.$datan->value.'"'.$selected.'>'.$datan->label.'</option>\n';
		}
		
		$sqlc = "SELECT DISTINCT r.mid, r.did, r.nid, r.cid, 
		c.cid AS ccid, c.value AS value, c.label AS label
		
		FROM {price_relations} AS r 
		INNER JOIN {price_colors} AS c ON r.cid=c.cid
		
		WHERE r.mid=%d AND r.did=%d AND r.nid=%d";
		$resultc = db_query($sqlc,$data_r->mid,$data_r->did,$data_r->nid);
		while($datac = db_fetch_object($resultc)){
			$data_r->cid==$datac->ccid ? $selected = ' selected=selected' : $selected = '';
			$output['colors'] .= '<option value="'.$datac->value.'"'.$selected.'>'.$datac->label.'</option>\n';
		}
		print_r($output['materials'].'|'.$output['dimensions'].'|'.$output['numbers'].'|'.$output['colors']);
	}
	elseif($_POST['step']=='change1'){
		$output['dimensions'] = '';
		$output['numbers'] = '';
		$output['colors'] = '';
		
		$sql_m = "select mid from {price_materials} where value='%s'";
		$result_m = db_query($sql_m,$_POST['material']);
		$data_m = db_fetch_object($result_m);
		$mid = $data_m->mid;
		
		$dimensions_default = '';
		$sqld = "SELECT DISTINCT d.did as ddid, d.value as dvalue, d.label as dlabel, d.weight,
		r.mid as rmid, r.did as rdid
		FROM {price_relations} as r
		INNER JOIN {price_dimensions} as d ON r.did=d.did
		WHERE r.mid=%d
		ORDER BY d.weight";
		$resultd = db_query($sqld,$mid);
		$idd=1;
		while($datad = db_fetch_object($resultd)){
			if($idd==1)$dimensions_default=$datad->dvalue;
			$output['dimensions'] .= '<option value="'.$datad->dvalue.'"'.$selected.'>'.$datad->dlabel.'</option>\n';
			$idd++;
		}
		
		$sql_d = "select did from {price_dimensions} where value='%s'";
		$result_d = db_query($sql_d,$dimensions_default);
		$data_d = db_fetch_object($result_d);
		$did = $data_d->did;
		
		$numbers_default = '';
		$sqln = "SELECT DISTINCT r.mid, r.did, r.nid, 
		n.nid AS nnid, n.value AS value, n.label AS label
		FROM {price_relations} AS r 
		INNER JOIN {price_numbers} AS n ON r.nid=n.nid
		WHERE r.mid=%d AND r.did=%d";
		$resultn = db_query($sqln,$mid,$did);
		$in=1;
		while($datan = db_fetch_object($resultn)){
			if($in==1)$numbers_default=$datan->value;
			$output['numbers'] .= '<option value="'.$datan->value.'"'.$selected.'>'.$datan->label.'</option>\n';
			$in++;
		}
		
		$sql_n = "select nid from {price_numbers} where value='%s'";
		$result_n = db_query($sql_n,$numbers_default);
		$data_n = db_fetch_object($result_n);
		$nid = $data_n->nid;
		
		$sqlc = "SELECT DISTINCT r.mid, r.did, r.nid, r.cid, 
		c.cid AS ccid, c.value AS value, c.label AS label
		FROM {price_relations} AS r 
		INNER JOIN {price_colors} AS c ON r.cid=c.cid
		WHERE r.mid=%d AND r.did=%d AND r.nid=%d";
		$resultc = db_query($sqlc,$mid,$did,$nid);
		while($datac = db_fetch_object($resultc)){
			$output['colors'] .= '<option value="'.$datac->value.'"'.$selected.'>'.$datac->label.'</option>\n';
		}
		
		print_r($output['dimensions'].'|'.$output['numbers'].'|'.$output['colors']);
	}
	elseif($_POST['step']=='change2'){
		$output['numbers'] = '';
		$output['colors'] = '';
		
		$sql_m = "select mid from {price_materials} where value='%s'";
		$result_m = db_query($sql_m,$_POST['material']);
		$data_m = db_fetch_object($result_m);
		$mid = $data_m->mid;
		
		$sql_d = "select did from {price_dimensions} where value='%s'";
		$result_d = db_query($sql_d,$_POST['dimension']);
		$data_d = db_fetch_object($result_d);
		$did = $data_d->did;
		
		$numbers_default = '';
		$sqln = "SELECT DISTINCT r.mid, r.did, r.nid, 
		n.nid AS nnid, n.value AS value, n.label AS label
		FROM {price_relations} AS r 
		INNER JOIN {price_numbers} AS n ON r.nid=n.nid
		WHERE r.mid=%d AND r.did=%d";
		$resultn = db_query($sqln,$mid,$did);
		$i=1;
		while($datan = db_fetch_object($resultn)){
			if($i==1)$numbers_default=$datan->value;
			$output['numbers'] .= '<option value="'.$datan->value.'"'.$selected.'>'.$datan->label.'</option>\n';
			$i++;
		}
		
		$sql_n = "select nid from {price_numbers} where value='%s'";
		$result_n = db_query($sql_n,$numbers_default);
		$data_n = db_fetch_object($result_n);
		$nid = $data_n->nid;
		
		$sqlc = "SELECT DISTINCT r.mid, r.did, r.nid, r.cid, 
		c.cid AS ccid, c.value AS value, c.label AS label
		FROM {price_relations} AS r 
		INNER JOIN {price_colors} AS c ON r.cid=c.cid
		WHERE r.mid=%d AND r.did=%d AND r.nid=%d";
		$resultc = db_query($sqlc,$mid,$did,$nid);
		while($datac = db_fetch_object($resultc)){
			$output['colors'] .= '<option value="'.$datac->value.'"'.$selected.'>'.$datac->label.'</option>\n';
		}
		
		print_r($output['numbers'].'|'.$output['colors']);
	}
	elseif($_POST['step']=='change3'){
		$output['colors'] = '';
		$sql_r = "select mid,did,nid,cid from {price_relations} where start=1";
		$data_r = db_fetch_object(db_query($sql_r));
		
		$sql_m = "select mid from {price_materials} where value='%s'";
		$result_m = db_query($sql_m,$_POST['material']);
		$data_m = db_fetch_object($result_m);
		$mid = $data_m->mid;
		
		$sql_d = "select did from {price_dimensions} where value='%s'";
		$result_d = db_query($sql_d,$_POST['dimension']);
		$data_d = db_fetch_object($result_d);
		$did = $data_d->did;
		
		$sql_n = "select nid from {price_numbers} where value='%s'";
		$result_n = db_query($sql_n,$_POST['number']);
		$data_n = db_fetch_object($result_n);
		$nid = $data_n->nid;
		
		$sqlc = "SELECT DISTINCT r.mid, r.did, r.nid, r.cid, 
		c.cid AS ccid, c.value AS value, c.label AS label
		FROM {price_relations} AS r 
		INNER JOIN {price_colors} AS c ON r.cid=c.cid
		WHERE r.mid=%d AND r.did=%d AND r.nid=%d";
		$resultc = db_query($sqlc,$mid,$did,$nid);
		while($datac = db_fetch_object($resultc)){
			$output['colors'] .= '<option value="'.$datac->value.'"'.$selected.'>'.$datac->label.'</option>\n';
		}
		print_r($output['colors']);
	}
	elseif($_POST['step']=='change4'){
		$nl = chr(13).chr(10);
		
		$sql_m = "select * from {price_materials} where value='%s'";
		$result_m = db_query($sql_m,$_POST['material']);
		$data_m = db_fetch_object($result_m);
		$mid = $data_m->mid;
		
		$sql_d = "select * from {price_dimensions} where value='%s'";
		$result_d = db_query($sql_d,$_POST['dimension']);
		$data_d = db_fetch_object($result_d);
		$did = $data_d->did;
		
		$sql_n = "select * from {price_numbers} where value='%s'";
		$result_n = db_query($sql_n,$_POST['number']);
		$data_n = db_fetch_object($result_n);
		$nid = $data_n->nid;
		
		$sql_c = "select * from {price_colors} where value='%s'";
		$result_c = db_query($sql_c,$_POST['color']);
		$data_c = db_fetch_object($result_c);
		$cid = $data_c->cid;
		
		$sql = "select * from {price_relations} where mid=%d and did=%d and nid=%d and cid=%d";
		$result = db_query($sql,$mid,$did,$nid,$cid);
		$data = db_fetch_object($result);
		
		$film_extras = variable_get('price_film_extra', '');
		$film_extras_array = explode($nl,$film_extras);
		
		$anz = $data_n->value;
		$dimension = $data_n->value;
		$colors = $data_c->value;
		$price = $data->price;
		
		foreach($film_extras_array as $fea){
			$tmp = explode('|',$fea);
			if($tmp[0]==$data_m->value && $dimension!=9){
				$value = $tmp[0]; $charge = str_replace(',','.',$tmp[1]); $quantity = $tmp[2];
				$aufschlag = $anz / 50 * $dimension;
				$aufschlag2 = $anz * $charge;
				if($dimension <= 50){
					$aufschlag += 0.1;
				}
			}
		}
		
		$output = $price + $aufschlag + $aufschlag2;
		print_r($output);
		//print_r($data->price);
	}
}